#!/usr/bin/env python
# Sort By Selected Column
# Copyright 2004 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 041217 - first version of this script

def hint(s):
    try:
        Data.Hint("%s: %s" % (scriptname, s))
    except AttributeError:
        self.SetStatusText(s)

def SortOnColumn(self):
    rid = self.ReportID  # current report

    # make sure exactly one column is selected
    s = self.Report.GetSelectedCols()  # current selection

    if len(s) != 1:
        hint('Must select a single column.')
        return  # do nothing

    colid = self.Report.table.columns[s[0]]  # column id number
    coloff = self.Report.table.coloffset[s[0]]  # column offset number

    trep = Data.Database['Report']
    trow = Data.Database['ReportRow']
    ttyp = Data.Database['ReportType']
    tid = trep[rid].get('ReportTypeID')
    if not tid: return  # all reports must have a type

    rlist = Data.GetRowList(rid)

    if len(rlist) < 2 : return  # don't sort if no rows or one row

    seq = {}  # capture current sequence
    for i, id in enumerate(rlist):
        seq[id] = i

    def mycmp(a, b):
        val = Data.GetCellValue(a, colid, coloff)
        a1 = (val, seq[a])

        val = Data.GetCellValue(b, colid, coloff)
        b1 = (val, seq[b])

        return cmp(a1, b1)

    rlist.sort(mycmp)
    Data.ReorderReportRows(rid, rlist)
    Data.SetUndo("Sort of Report Rows")

SortOnColumn(self)
